﻿<%@ Page Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<ProfileViewModel>" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">Plan My Night - Profile</asp:Content>

<asp:Content ContentPlaceHolderID="HtmlHeadContent" runat="server">
    <% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/jquery-1.3.2.min.js"), "http://ajax.Microsoft.com/ajax/jQuery/jquery-1.3.2.min.js"); %>
    <% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/jquery.validate.js"), "http://ajax.microsoft.com/ajax/jquery.validate/1.5.5/jquery.validate.min.js"); %>
    <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/MicrosoftMvcJQueryValidation.js"), "pmn"); %>
    <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.common.js"), "pmn"); %>
    <% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.profile.js"), "pmn"); %>
    <%= Ajax.RenderClientScripts() %>
</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">
<div class="panel" id="profileForm">
    <div class="innerPanel">
        <h2><span>My Profile</span></h2>

        <% Html.ClientValidationEnabled = true; %>
        <% using (Html.BeginForm("Update", "Account")) %>
        <% { %>
        <%=Html.AntiForgeryToken()%>
        <div class="items">
            <fieldset>
                <p>
                    <label for="FullName">Name:</label>
                    <%=Html.EditorFor(m => m.Profile.FullName)%>
                    <%=Html.ValidationMessage("Profile.FullName", new { @class = "field-validation-error-wrapper" })%>
                </p>
                <p>
                    <label for="State">State:</label>
                    <%=Html.DropDownListFor(m => m.Profile.State, Model.States)%>
                </p>
                <p>
                    <label for="City">City:</label>
                    <%=Html.EditorFor(m => m.Profile.City, Model.Profile.City)%>
                </p>
                <p>
                    <label for="PreferredActivityTypeId">Preferred activity:</label>
                    <%=Html.DropDownListFor(m => m.Profile.PreferredActivityTypeId, Model.PreferredActivityTypes)%>
                </p>
            </fieldset>
            <div class="submit">
                <%=Html.Hidden("returnUrl", Model.ReturnUrl)%>
                <%=Html.SubmitButton("submit", "Update")%>
            </div>
        </div>
        <div class="toolbox"></div>
        <% } %>
    </div>
</div>
</asp:Content>
